/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ButtonScreenModule
implements IScreenModule<IModuleDataBoolean> {
    private String line = "";
    private int channel = -1;
    private boolean toggle;

    public IModuleDataBoolean getData(IScreenDataHelper helper, Level worldObj, long millis) {
        if (this.channel != -1 && this.toggle) {
            RedstoneChannels channels = RedstoneChannels.getChannels(worldObj);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            return helper.createBoolean(ch.getValue() > 0);
        }
        return null;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.m_128461_("text");
            if (tagCompound.m_128441_("channel")) {
                this.channel = tagCompound.m_128451_("channel");
            }
            this.toggle = tagCompound.m_128471_("toggle");
        }
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
        int xoffset = !this.line.isEmpty() ? 80 : 5;
        if (x >= xoffset) {
            if (this.channel != -1) {
                if (this.toggle) {
                    if (clicked) {
                        RedstoneChannels.RedstoneChannel ch;
                        RedstoneChannels channels = RedstoneChannels.getChannels(world);
                        ch.setValue((ch = channels.getOrCreateChannel(this.channel)).getValue() == 0 ? 15 : 0);
                        channels.save();
                    }
                } else {
                    RedstoneChannels channels = RedstoneChannels.getChannels(world);
                    RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
                    ch.setValue(clicked ? 15 : 0);
                    channels.save();
                }
            } else if (player != null) {
                player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Module is not linked to redstone channel!"), false);
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.BUTTON_RFPERTICK.get();
    }
}

